function [out params]=SimulateCVineTC(data,t,dof)
% code to simulate a canonical vine based on bivariate T copula
% INPUTS:
% data: A matrix of U(0,1) variables or a positive integer. In case you
% provide a matrix, the correlation parameters  will be equal to the sample
% parameters from data, for example the parameter of the C24|1, which is
% the partial correlation of variables 2 and 4, given 1, will be equal to
% the partial correlation of columns 2 and 4, given column 1, from the data.
% If you provide a positive integer, the theta parameters will also be
% simulated.
% t: The size of the simulated data (number of rows)
% dof: the degree of freedom parameters for the bivariate copula
% (optional). If provided it should be a column vector with N(N-1)/2 rows
% OUTPUTS:
% out: The simulated data
% params: A structure that contains the rho's and dof's used for the
% simulation.
% ------------------------------------------------------------------------
% Author: Manthos Vogiatzoglou, UoM, 2008 - 2009
% contact at: vogia@yahoo.com

if isscalar(data)==1
[CVine,rho]=CVineStruct(data); % create theta parameters
N=data;
else
[CVine,rho]=CVineStruct(data); % create theta parameters
N=size(data,2);
end
if nargin==2 || isempty(dof)
    dof=linspace(5,80,N*(N-1)/2)';
end
if size(dof,1)~=N*(N-1)/2 || size(dof,2)~=1
    display('the dof should be a column vector with N(N-1)/2 rows')
    display('a linearly spaced dof vector is loaded')
    dof=linspace(5,80,N*(N-1)/2)';
end
dof=crIPmat(dof);
w=rand(t,N);
out=zeros(size(w));
out(:,1)=w(:,1);
u=cell(N,N);
u{1,1}=w(:,1);
for i=2:N
    u{i,1}=w(:,i);
    l=linspace(i-1,1,i-1); s=length(l);
    for k=1:s
        u{i,1}=invhfuncTC(u{i,1},u{l(k),l(k)},dof(l(k),i-l(k)),rho{l(k),i-l(k)});
    end
    out(:,i)=u{i,1};
    if i<N
    for j=1:(i-1)
        u{i,j+1}=hfuncTC(u{i,j},u{j,j},dof(j,i-j),rho{j,i-j});
    end
    end
end
params.rho=rho;
params.dof=dof;